	#include <Servo.h>

#define SERVOPIN   9
#define ACTIVEPIN  3
#define TESTPIN    2
#define OUTPIN		 11
#define SENSOR1		 13
#define SENSOR2		 14

#define MOVESPEED	 7
#define STARTPOS 	1000
#define MINPOS    1000
#define MAXPOS		2200
#define MINMOVE		200

bool havehit;
bool moving;
bool gameactive;
bool currswitchstate;

int sensorval1;
int sensorval2;
int currentsensormax1;
int currentsensormax2;
int currentpos;
int newpos;
int movespeed;
int hitcounter;
int lastval;
int testread;
long randNumber;

unsigned long servotimer;

Servo myServo;

void setup () {
	pinMode(SENSOR1,INPUT);
	pinMode(SENSOR2,INPUT);
	
	pinMode(OUTPIN,OUTPUT);
	pinMode(ACTIVEPIN,INPUT_PULLUP);
	pinMode(TESTPIN,INPUT_PULLUP);
	testread = digitalRead(TESTPIN);
	
	digitalWrite(OUTPIN,HIGH);

	Serial.begin(115200);
	
	randomSeed(analogRead(2));
	myServo.attach(SERVOPIN,200,2500);
	myServo.write(1000);
	
	currentsensormax1 = analogRead(0);
	currentsensormax2 = analogRead(1);
	for (int i=0; i < 40; i++) {
		currentsensormax1 = (currentsensormax1 + analogRead(0)) / 2;
		currentsensormax2 = (currentsensormax2 + analogRead(1)) / 2;
		delay(10);
	}
	
	currswitchstate = false;
	
	servotimer = 0;
	currentpos = 600;
	moving = true;
	gameactive = true;
	havehit = false;
	hitcounter = 0;
	lastval = 0;
}	

void loop () {

	if (!moving && !havehit) {
		digitalWrite(OUTPIN,HIGH);
		sensorval1 = analogRead(0);
		sensorval2 = analogRead(1);

		if (abs(currentsensormax1 - sensorval1) > 50) {
			hitcounter++;
			Serial.print(F("Sensor value: "));
			Serial.println(sensorval1);
			Serial.print(F("Difference: "));
			Serial.println(lastval);
			havehit = true;
		}
	}
		
	if (readswitch(ACTIVEPIN)) {
		if (!currswitchstate) {
			gameactive = true;
			Serial.println(F("Game set to active"));
			moving = true;
			havehit = false;
		} else {
			gameactive = false;
			Serial.println(F("Game set to stop"));
		}
	}
	
	if (gameactive) {
		
		if (havehit) {
			digitalWrite(OUTPIN,LOW);
			moving = true;
			havehit = false;
		}
  	
		if (moving) {
			if (!servotimer) {
				newpos = currentpos;
				//
				if (! digitalRead(TESTPIN)) {
					Serial.print(F("Testing max positions"));
					if (newpos > 1500) {
						newpos = MINPOS;
					} else {
						newpos = MAXPOS;
					}
				} else {
					while (abs(newpos - currentpos) < MINMOVE) {
						newpos = random(MAXPOS - MINPOS) + MINPOS;
					}
				}
				
				if (newpos > currentpos) {
					movespeed = MOVESPEED;
				} else {
					movespeed = -MOVESPEED;
				}
				
				Serial.print(F("moving to new position: "));
				Serial.println(newpos);
				servotimer = millis();
			}
			
			if (millis() - servotimer > 10) {
				currentpos += movespeed;
				myServo.writeMicroseconds(currentpos);
				servotimer = millis();
			}
			if (movespeed > 0 && currentpos >= newpos) {
				currentpos = newpos;
			}
			if (movespeed < 0 && currentpos <= newpos) {
				currentpos = newpos;
			}
			
			if (currentpos == newpos) {
				servotimer = 0;
				moving = false;
				for (int i=0; i < 40; i++) {
					currentsensormax1 = (currentsensormax1 + analogRead(0)) / 2;
					delay(10);
				}
				Serial.println(F("waiting for a hit"));
				Serial.print(F("new sensor value: "));
				Serial.println(currentsensormax1);
			}
		}
	} else {
		moving = true;
		servotimer = 0;
	}
}


bool readswitch (int switchpin) {
	int switchpos = digitalRead(switchpin);	
	bool doswitch = false;
  
	if ((switchpos == 0) && !currswitchstate) {
    currswitchstate = true;
		doswitch = true;
	}
	if ((switchpos == 1) && currswitchstate) {
    currswitchstate = false;
    doswitch = true;
	}
	
	return doswitch;
}
