/*
 * Het programma voor JOTI arduino project.
 * Lees het commentaar aandachtig door en maak de veranderingen die je wil!
 * 
 * verander de #include regels niet..
 */

#include "SevenSegmentTM1637.h"
#include "SevenSegmentFun.h"
#include "dht.h"
#include "Wire.h"

/*
 * Geef aan welk programma je wil laten werken:
 * 
 * programma 1 = Temperatuur meter, deze wisselt temperatuur en luchtvochtigheid af. De functie van de schakelaar is in te stellen verderop.
 * programma 2 = Stopwatch, de functie van de schakelaar is: start, stop, reset en dan weer start, enz.
 * programma 3 = reactietijd spelletje. Er verschijnt WAIT en de dubbele punt knippert een willekeurig aantal keren. Zodra de teller begint te lopen druk je zo snel mogelijk op de knop. 
 *							 Het getal is je reactiesnelheid. Als er niets gebeurd, dan verschijnt STOP. Verschijnen er allemaal lijnen, dan is te vroeg gedrukt. 
 *							 Door nog een keer op de knop te drukken wordt het spelletje gereset en kan een nieuwe poging gedaan worden.
 * programma 4 = display fun
 * programma 9 = sensor test (let op, hiervoor moet de serial monitor aan staan!)
 */
#define PROGRAMMA 1

/*
 * zet de helderheid van het display, 0 tot 100
 */
#define BRIGHTNESS 20 

/*
 * Bij programma nummer 1, de functie van de schakelaar:
 * 0 - geen functie, er wordt automatisch heen en weer geschakeld volgens de opgegeven DISPLAYDELAY en het display is altijd aan
 * 1 - het display is altijd aan en je schakelt zelf tussen temperatuur en luchtvochtigheid. DISPLAYDELAY geeft de update tijd aan van het display
 * 2 - standaard is het display uit, maar na 1 keer drukken zal het display zo lang aan staan als in DISPLAYOFF staat
 * 3 - combinatie van 1 en 2
 */
 
#define SCHAKELAARFUNCTIE 2

/*
 * Deze tijd geeft aan hoe snel de weergave gewisseld wordt, in seconden. 
 * bij programma 1 (de temperatuur meter) geeft het aan hoe snel gewisseld wordt tussen temperatuur en luchtvochtigheid.
 * let op: als schakelaarfunctie op 1 of 3 staat, heeft deze tijd geen enkel nut.
 */
#define DISPLAYDELAY 2

/*
 * deze tijd geeft aan hoe lang het scherm aan blijft, in seconden
 */

#define DISPLAYOFF 4

/*
 * de temperatuur correctie. 
 * Zet deze bij de eerste keer testen op 0. Lees dan de gemiddelde temperatuur af, en vergelijk die met de thermometer.
 * je weet dan wat er bij of af moet, en vul dat hieronder in.
 */
#define TCORRECTIE 0

/*
 * De luchtvochtigheid correctie. 
 * zet deze bij de eerste keer testen op 0. Lees dan de luchtvochtigheid ad en vergelijk die met de thermometer.
 * je weet dan wat er bij of af moet en vul dat hieronder in.
 */
#define HCORRECTIE 0



/**********************************************************************************************
 **********************************************************************************************
 * Niets meer aan te passen, alles dat hier na komt moet blijven zoals het is.
 */
//Pins for TM1637
#define CLK 3 		
#define DIO 2
#define SWITCHPIN1 12
#define SWITCHPIN2 7

#define DISPLAYDELAYMILLIS DISPLAYDELAY * 1000
#define DISPLAYOFFMILLIS DISPLAYOFF * 1000

SevenSegmentFun    display(CLK, DIO);
dht12 sensor(0x5c);
uint8_t buffer[4];
int switches[2][2] = {{SWITCHPIN1,0},{SWITCHPIN2,0}};
int runningprogram = PROGRAMMA;
int prevprogram = PROGRAMMA;
int tempsave = 0;
int humidsave = 0;
int hour = 0;
int minute = 0;
int second = 0;
int displaystate = 0;
bool displayupdate = false;
bool displayon = true;
unsigned long readtimer = 0;
unsigned long displaytimer = 0;
unsigned long timeout = 0;

void setup(){
	Serial.begin(9600);
  Wire.begin();
  display.begin();
  display.setBacklight(BRIGHTNESS);
  display.clear();
  display.print(F("INIT"));
  pinMode(SWITCHPIN1,INPUT_PULLUP);
  pinMode(SWITCHPIN2,INPUT_PULLUP);
  /* pullup en input voor 9 en 10, deze hangen aan gnd door de schakelaars! */
  pinMode(9,INPUT_PULLUP);
  pinMode(10,INPUT_PULLUP);
  randomSeed(analogRead(0));
  delay(200);
  switches[0][1] = digitalRead(SWITCHPIN1);
  switches[1][1] = digitalRead(SWITCHPIN2);
 }
 
void loop(){
 	if (runningprogram == 1) { temphum(); }
 	if (runningprogram == 2) { stopwatch(); }
 	if (runningprogram == 3) { reactiesnelheid(); }
  if (runningprogram == 4) { displaytest(); }
  if (runningprogram == 9) { sensortest(); }
  if (prevprogram != runningprogram) {
    display.setBacklight(BRIGHTNESS);
    display.clear();
    displaystate = 0;
    displayupdate = true;
    displayon = true;
    readtimer = 0;
    displaytimer = 0;
    timeout = 0;
  }
  prevprogram = runningprogram;
}


bool readswitch (int switchnr) {
	int switchpos = digitalRead(switches[switchnr][0]);	
	bool doswitch = false;
	
	if ((switchpos == 0) && (switches[switchnr][1] == 1)) {
		delay(100);
		doswitch = true;
	}
	if ((switchpos == 1) && (switches[switchnr][1] == 0)) {
		delay(100);
	}
 
	switches[switchnr][1] = switchpos;

  if ((switchnr == 1) && (doswitch)) {
    runningprogram++;
    if (runningprogram > 4) {
      runningprogram = 1;
    }
  }
	return doswitch;
}
	


/*
 * temperatuur meter
 */
void temphum (void) {
	displayupdate = false;
	
	bool doswitch = false;
	
	if ((millis() - readtimer > 2000) || (displaystate == 0)) {
		dht::ReadStatus chk = sensor.read();
		readtimer = millis();
		if (tempsave == 0) {
			tempsave = sensor.getTemperature();
		} else {
			tempsave = ((tempsave * 4) + sensor.getTemperature()) / 5;
		}
		if (humidsave == 0) {
			humidsave = sensor.getHumidity();
		} else {
			humidsave = ((humidsave * 4) + sensor.getHumidity()) / 5;
		}
	}
	
	doswitch = readswitch(0);
  readswitch(1);

	if (millis() - displaytimer > DISPLAYDELAYMILLIS) {
		displaytimer = millis();
		displayupdate = true;
	}
	
	switch (SCHAKELAARFUNCTIE) {
		case 0: // automatisch zelf display switchen
						if ((displayupdate) || (displaystate == 0)) {
							if (displaystate == 1) {
								displaystate = 2;
							} else {
								displaystate = 1;
							}
							displayupdate = true;
						}
						break;
						
		case 1: // display switch dmv schakelaar
						if (doswitch || (displaystate == 0)) {
							if (displaystate == 1) {
								displaystate = 2;
							} else {
								displaystate = 1;
							}
							displayupdate = true;
						}
						break;

		case 2: // functie 0 plus automatisch display off
						if (doswitch || (displaystate == 0)) {
							timeout = millis();
							displayupdate = true;
							if (! displayon) {
								displaystate = 0;
								displaytimer = timeout;
							}
						}
						if (displayupdate) {
							if (displaystate == 1) {
								displaystate = 2;
							} else {
								displaystate = 1;
							}
						}	
						if (millis() - timeout > DISPLAYOFFMILLIS) {
							displayupdate = false;
							if (displayon) {
								displayon = false;
								display.off();
							}
						}
						break;
						
						
		case 3: // functie 1 en automatisch display off
						if (doswitch || (displaystate == 0)) {
							if (displaystate == 1) {
								displaystate = 2;
							} else {
								displaystate = 1;
							}
							if (! displayon) {
								displaystate = 1;
							}
							timeout = millis();
							displayupdate = true;
						}
						if (millis() - timeout > DISPLAYOFFMILLIS) {
							displayupdate = false;
							if (displayon) {
								displayon = false;
								display.off();
							}
						}
						break;

	}
	
	if (displayupdate) {
		displayon = true;
		display.setBacklight(BRIGHTNESS);
		display.clear();
		switch (displaystate) {
			case 1: display.print(String( int ( (tempsave / 10) + TCORRECTIE) ) + F(" C"));
							break;
			case 2: display.print(String( int ( (humidsave / 10) + HCORRECTIE) ) + F(" H"));
							break;
		}
	}
}

/*
 * Stopwatch
 */
void stopwatch (void) {
	displayupdate = false;
	readswitch(1);
	if (readswitch(0)) {
		switch (displaystate) {
			case 1: displaystate = 2;
							break;
			case 2: displaystate = 3; 
							break;
			case 3: displaystate = 0;
							break;
		}		
	}
	
	
	switch (displaystate) {
		case 0: minute = 0;
						second = 0;
						display.setColonOn(true);
						displayupdate = true;
						displaystate = 1;
						break;
		case 2: if (millis() - displaytimer > 1000) {
							displaytimer = millis();
							displayupdate = true;
							second++;
							if (second > 59) {
								minute++;
								second = 0;
								if (minute > 59) {
									minute = 0;
								}
							}
						}
						break;
	}
						
	if (displayupdate) {
	  buffer[0] = display.encode(int16_t(minute / 10));
  	buffer[1] = display.encode(int16_t(minute % 10));
  	buffer[2] = display.encode(int16_t(second / 10));
  	buffer[3] = display.encode(int16_t(second % 10));

  	display.printRaw(buffer, 4, 0);
  	displayupdate = false;
  }
	
}

/*
 * Reactiesnelheid test
 */
void reactiesnelheid (void) {
	
	int waitcount = (random(100) % 10) + 3;
	int k = 0;
	bool doton = true;
	bool switchpressed = false;
  bool prgswitch = false;
	
	display.setBacklight(BRIGHTNESS);
	display.clear();
	display.print(F("WAIT"));
	delay(1000); // tijd om de button los te laten.
	switchpressed = readswitch(0);
  prgswitch = readswitch(1);
	timeout = millis();
	while ((k < waitcount) && (! switchpressed) && (! prgswitch)) {
		switchpressed = readswitch(0);
    prgswitch = readswitch(1);
		if (millis() - timeout > 1000) {
			timeout = millis();
			k++;
			display.setColonOn(doton);
			display.print(F("WAIT"));
			doton = !doton;
		}
	}
	display.setColonOn(false);
	display.clear();
	
	if (switchpressed) {
		// te vroeg gedrukt
		buffer[0] = B01001001;
		buffer[1] = B01001001;
		buffer[2] = B01001001;
		buffer[3] = B01001001;
		display.clear();
		for (k = 0; k < 5; k++) {
			display.printRaw(buffer,4,0);
			delay(500);
			display.clear();
			delay(500);
		}
	} else {
    if (! prgswitch) {
		  Serial.println(F("Start the count!"));
		  buffer[0] = 0; 
		  buffer[1] = 0;
		  buffer[2] = 0;
		  buffer[3] = 0;
		
		  while ((! readswitch(0)) && (! readswitch(1)) && (buffer[0] < 9)) { 
			  buffer[3]++;
			  for (k=3; k > 0; k--) {
				  if (buffer[k] > 9) { 
					  buffer[k-1]++; 
					  buffer[k] = 0;
				  }
			  }
			  display.clear();
			  for (k = 0; k < 4; k++) {
				  display.printRaw(display.encode(int16_t(buffer[k])),k);
			  }
		  }
		
		  if (buffer[0] == 9) {
			  display.print(F("STOP"));
		  }
    }
	}
	//delay(1000);
	while ((! readswitch(0)) && (! readswitch(1)) && (! prgswitch)) {
		// niks te doen, wachten tot button is gedrukt om te resetten.
	}
	
}



/*
 * De display tester
 */
void displaytest (void) {
  bool doswitch = false;
	snow(50);
  doswitch = readswitch(1);
  if (! doswitch) {
	  display.bouchingBall(30,100);
    doswitch = readswitch(1);
  }
  if (! doswitch) {
	  display.snake(5);
    doswitch = readswitch(1);
  }
  if (! doswitch) {
	  buffer[0] = 0;
	  buffer[1] = 0;
	  buffer[2] = 0;
	  buffer[3] = 0x01;
	  snake2(10);
    doswitch = readswitch(1);
  }
  if (! doswitch) {
  	drop(100);
    doswitch = readswitch(1);
  }
  if (! doswitch) {
	  display.bombTimer(2, 30, 10000, (char) " GO ");
    doswitch = readswitch(1);
  }
}

/*
 * de sensor tester
 */
void sensortest (void) {
  unsigned long b = micros();
  dht::ReadStatus chk = sensor.read();
  unsigned long e = micros();

  Serial.print(F("\nRead sensor: "));
  switch (chk)
  {
    case dht::OK:
      Serial.print(F("OK, took "));
      Serial.print (e - b); Serial.println(F(" usec"));
      break;
    case dht::ERROR_CHECKSUM:
      Serial.println(F("Checksum error"));
      break;
    case dht::ERROR_TIMEOUT:
      Serial.println(F("Timeout error"));
      break;
    case dht::ERROR_CONNECT:
      Serial.println(F("Connect error"));
      break;
    case dht::ERROR_ACK_L:
      Serial.println(F("AckL error"));
      break;
    case dht::ERROR_ACK_H:
      Serial.println(F("AckH error"));
      break;
    default:
      Serial.println(F("Unknown error"));
      break;
  }

  Serial.print(F("Humidity (%): "));
  Serial.println(sensor.getHumidity());

  Serial.print(F("Temperature (°C): "));
  Serial.println(sensor.getTemperature());

  Serial.print(F("Dew Point (°C): "));
  Serial.println(sensor.dewPoint());

  delay(1000);
}

void snake2 (int loops) {	
	for (int k = 0; k < loops; k++) {
		if (random(100) > 60) {
			buffer[3] = buffer[3] | 0x01;
		}
		for (int j=0; j < 16; j++) {
			for (int i = 0; i < 4; i++) {
				if (buffer[i] > 0) {
					buffer[i] = buffer[i] << 1;
				}
				if (buffer[i] > 60) {
					buffer[i] = 0;
					if (i == 0) { buffer[3] = buffer[3] | B00000010; }
					else { buffer[i-1] = buffer[i-1] | B00000010; }
				}
			}
			display.printRaw(buffer,4,0);
			delay(100);
		}
	}
}

void snow (int loops) {
	for (int k = 0; k < loops; k++) {
		buffer[0] = random(2000) & B01111111;
		buffer[1] = random(3000) & B01111111;
		buffer[2] = random(2000) & B01111111;
		buffer[3] = random(4000) & B01111111;
		display.printRaw(buffer,4,0);
		delay(100);
	}
}

void drop (int loops) {
	for (int k=0; k < loops; k++) {
		for (int i=3; i > 0; i--) {
			buffer[i] = buffer[i-1];
		}		
		buffer[0] = random(1000) & B01001001;
		if (random(100) > 60) { 
			buffer[0] = 0;
		}
		display.printRaw(buffer,4,0);
		delay(100);
	}
}
